using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace MojaDrugaGraXNA
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        //BasicEffect efekt;
        Effect efekt;
        Vector3 PolozenieKamery = new Vector3(0, 0, 2.5f);
        Matrix World = Matrix.Identity, ViewProjection;

        public Game1()
        {
            Window.Title = "Modul 1. XNA - Szybki start: Laboratorium 1";

            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            //efekt                        
            /*
            efekt = new BasicEffect(graphics.GraphicsDevice, null);
            efekt.VertexColorEnabled = true;
            efekt.Projection = Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);
            efekt.View = Matrix.CreateLookAt(new Vector3(0, 0, 2.5f), new Vector3(0, 0, 0), new Vector3(0, 1, 0));
            */

            //prostopadloscian            
            //this.Components.Add(new Prostopadloscian(this, efekt, 1.5f, 1.0f, 2.0f, Color.White));
            //this.Components.Add(new Prostopadloscian(this, efekt, 1.5f, 1.0f, 2.0f, Color.Crimson));

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            efekt = Content.Load<Effect>("efekt");
            ViewProjection =
                Matrix.CreateLookAt(PolozenieKamery, new Vector3(0, 0, 0), new Vector3(0, 1, 0)) *
                Matrix.CreatePerspective(2.0f * graphics.GraphicsDevice.Viewport.AspectRatio, 2.0f, 1.0f, 100.0f);
            //efekt.Parameters["Kolor"].SetValue(Color.Yellow.ToVector4());
            //efekt.Parameters["KopiujKolorWerteksu"].SetValue(false);
            efekt.Parameters["WVP"].SetValue(World * ViewProjection);
            efekt.Parameters["World"].SetValue(World);
            efekt.Parameters["PolozenieKamery"].SetValue(PolozenieKamery);

            //prostopadloscian            
            this.Components.Add(new Prostopadloscian(this, efekt, ViewProjection, 1.5f, 1.0f, 2.0f, Color.White));
            this.Components.Add(new Prostopadloscian(this, efekt, ViewProjection, 1.5f, 1.0f, 2.0f, Color.Crimson));
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            //klawiatura
            if (Keyboard.GetState().IsKeyDown(Keys.Escape)) this.Exit();
            if (Keyboard.GetState().IsKeyDown(Keys.Space)) graphics.ToggleFullScreen();            

            /*
            efekt.World *=
                Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f) *
                Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);
            */
            World *=
                Matrix.CreateRotationX(gameTime.ElapsedGameTime.Milliseconds / 1000.0f) *
                Matrix.CreateRotationY(gameTime.ElapsedGameTime.Milliseconds / 1000.0f);

            //(this.Components[0] as Prostopadloscian).World = efekt.World * Matrix.CreateScale(0.75f) * Matrix.CreateTranslation(-1, 0, 0);
            //(this.Components[1] as Prostopadloscian).World = efekt.World * Matrix.CreateScale(0.75f) * Matrix.CreateTranslation(1, 0, 0);
            (this.Components[0] as Prostopadloscian).World = World * Matrix.CreateScale(0.75f) * Matrix.CreateTranslation(-1, 0, 0);
            (this.Components[1] as Prostopadloscian).World = World * Matrix.CreateScale(0.75f) * Matrix.CreateTranslation(1, 0, 0);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice gd = graphics.GraphicsDevice;
            gd.Clear(Color.Black);
            gd.RasterizerState = RasterizerState.CullNone;
            /*
            gd.VertexDeclaration = new VertexDeclaration(gd, VertexPositionColor.VertexElements);

            efekt.Begin();
            foreach (EffectPass pass in efekt.CurrentTechnique.Passes)
            {
                pass.Begin();
                
                pass.End();
            }
            efekt.End();
            */

            base.Draw(gameTime);
        }

    }
}
